VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6360
   ClientLeft      =   1680
   ClientTop       =   1800
   ClientWidth     =   8400
   LinkTopic       =   "Form1"
   ScaleHeight     =   6360
   ScaleWidth      =   8400
   Begin VB.Frame Frame5 
      Caption         =   "Fourth Channel/Gain List Pair"
      Height          =   735
      Left            =   2880
      TabIndex        =   26
      Top             =   4200
      Width           =   4815
      Begin VB.ComboBox chan 
         Height          =   315
         Index           =   3
         Left            =   960
         TabIndex        =   28
         Text            =   "0"
         Top             =   240
         Width           =   735
      End
      Begin VB.ComboBox gain 
         Height          =   315
         Index           =   3
         Left            =   2880
         TabIndex        =   27
         Text            =   "Bipolar Gain of 1"
         Top             =   240
         Width           =   1695
      End
      Begin VB.Label Label10 
         Caption         =   "Channel: "
         Height          =   255
         Left            =   240
         TabIndex        =   30
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label9 
         Caption         =   "Gain: "
         Height          =   255
         Left            =   2040
         TabIndex        =   29
         Top             =   360
         Width           =   615
      End
   End
   Begin VB.Frame Frame4 
      Caption         =   "Third Channel/Gain List Pair"
      Height          =   735
      Left            =   2880
      TabIndex        =   21
      Top             =   3240
      Width           =   4815
      Begin VB.ComboBox chan 
         Height          =   315
         Index           =   2
         Left            =   960
         TabIndex        =   23
         Text            =   "0"
         Top             =   240
         Width           =   735
      End
      Begin VB.ComboBox gain 
         Height          =   315
         Index           =   2
         Left            =   2880
         TabIndex        =   22
         Text            =   "Bipolar Gain of 1"
         Top             =   240
         Width           =   1695
      End
      Begin VB.Label Label8 
         Caption         =   "Channel: "
         Height          =   255
         Left            =   240
         TabIndex        =   25
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label7 
         Caption         =   "Gain: "
         Height          =   255
         Left            =   2040
         TabIndex        =   24
         Top             =   360
         Width           =   615
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Second Channel/Gain List Pair"
      Height          =   735
      Left            =   2880
      TabIndex        =   16
      Top             =   2280
      Width           =   4815
      Begin VB.ComboBox chan 
         Height          =   315
         Index           =   1
         Left            =   960
         TabIndex        =   18
         Text            =   "0"
         Top             =   240
         Width           =   735
      End
      Begin VB.ComboBox gain 
         Height          =   315
         Index           =   1
         Left            =   2880
         TabIndex        =   17
         Text            =   "Bipolar Gain of 1"
         Top             =   240
         Width           =   1695
      End
      Begin VB.Label Label6 
         Caption         =   "Channel: "
         Height          =   255
         Left            =   240
         TabIndex        =   20
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label5 
         Caption         =   "Gain: "
         Height          =   255
         Left            =   2040
         TabIndex        =   19
         Top             =   360
         Width           =   615
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "First Channel/Gain List Pair"
      Height          =   735
      Left            =   2880
      TabIndex        =   11
      Top             =   1320
      Width           =   4815
      Begin VB.ComboBox gain 
         Height          =   315
         Index           =   0
         Left            =   2880
         TabIndex        =   13
         Text            =   "Bipolar Gain of 1"
         Top             =   240
         Width           =   1695
      End
      Begin VB.ComboBox chan 
         Height          =   315
         Index           =   0
         Left            =   960
         TabIndex        =   12
         Text            =   "0"
         Top             =   240
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Gain: "
         Height          =   255
         Left            =   2040
         TabIndex        =   15
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label3 
         Caption         =   "Channel: "
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   360
         Width           =   615
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   495
      Left            =   7200
      TabIndex        =   10
      Top             =   5400
      Width           =   735
   End
   Begin VB.Frame Frame1 
      Caption         =   "Sample Rate (Hz)"
      Height          =   1335
      Left            =   720
      TabIndex        =   6
      Top             =   1320
      Width           =   1815
      Begin VB.OptionButton Option1 
         Caption         =   "10 KHz"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   9
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "1000 Hz"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   8
         Top             =   600
         Value           =   -1  'True
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "100 Hz"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   7
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2880
      TabIndex        =   4
      Text            =   "0"
      Top             =   720
      Width           =   615
   End
   Begin VB.ListBox List1 
      Height          =   1230
      Left            =   720
      TabIndex        =   3
      Top             =   3600
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Scan AI channels"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   3000
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   720
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   4920
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   5760
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number: "
      Height          =   255
      Left            =   2880
      TabIndex        =   5
      Top             =   360
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
Dim SampleRate As Single
Dim AIData() As Single
' tested in Win2K SP4 with KPCMCIA-850A04.0.0.2 DriverLINX version
'
' for multi channel analog input, there is a BUG:
' as soon as the task is started, a buffer filled message will
' be sent immediately.  This data in this false buffer filled message
' is junk.  Workaround:  ask for N+1 buffers and ignore the first buffer.
'
' This effect is not seen for single channel tasks.

Private Sub cmdExit_Click()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpcaiao"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = devNum.ListIndex
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.Refresh
Form1.Caption = "Channel/Gain List with " & LDD.Dev_Model  'from the LDD, determine the model number
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()
List1.Clear  ' clear the list box
SetupAIPaced

'SR.Req_op_edit = True
'SR.Refresh

SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
End Sub

Private Sub Form_Load()
' load devNum with legal values
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it to first entry
devNum.ListIndex = 0

' set SampleRate equal to the default radio button, 100Hz
SampleRate = 1000

' populate the channel combo boxes with values
Dim j As Integer
For j = 0 To 3
For i = 0 To 7
chan(j).AddItem Str(i), i
Next i
Next j

For j = 0 To 3
chan(j).ListIndex = 0
Next j

' populate the gain combo boxes
For j = 0 To 3
gain(j).AddItem "Bipolar Gain of 1", 0
gain(j).AddItem "Bipolar Gain of 2", 1
gain(j).AddItem "Bipolar Gain of 4", 2
gain(j).AddItem "Bipolar Gain of 8", 3
Next j
' the KPCI-3108, KPCI-3107 and KPCI-180xHC boards can mix unipolar and bipolar channels.  So
' other entries could be added to the gain combo box to represent these unipolar ranges as well
' as the other gains offered by the board.
'
' the KPCI-3101, etc covered by the kpci3100 driver can not mix Unipolar and Bipolar.  This
' selection applies to all channels on the board.
For j = 0 To 3
gain(j).ListIndex = 0
Next j
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAIPaced()
Dim i As Integer
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically when buffer is filled
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_rateOnCount = 0   ' not used for RATEGEN
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / SampleRate) ' 1000Hz default rate
.Evt_Tim_ratePulses = 0  ' not used for RATEGEN
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 4                ' 4 means a chan/gain list of 4 entries
For i = 0 To 3
.Sel_chan_list(i) = chan(i).ListIndex  ' get the selected entry from the array of combo boxes
Select Case gain(i).ListIndex
Case 0: .Sel_chan_gainCodeList(i) = .DLGain2Code(-1)
Case 1: .Sel_chan_gainCodeList(i) = .DLGain2Code(-2)  ' if -12AIH card, change to -10
Case 2: .Sel_chan_gainCodeList(i) = .DLGain2Code(-4)  ' if -12AIH card, change to -100
Case 3: .Sel_chan_gainCodeList(i) = .DLGain2Code(-8)  ' if -12AIH card, change to -1000
End Select
Next i

' allocate one buffer of .Sel_chan_N samples for the data
.Sel_buf_N = 2                 ' ask for N+1 buffers
.Sel_buf_samples = .Sel_chan_N
' the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub



Private Sub Option1_Click(Index As Integer)
Select Case Index
Case 0: SampleRate = 100
Case 1: SampleRate = 1000  'default value for this example
Case 2: SampleRate = 10000
End Select
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
' tested in Win2K SP4 with KPCMCIA-850A04.0.0.2 DriverLINX version
'
' for multi channel analog input, there is a BUG:
' as soon as the task is started, a buffer filled message will
' be sent immediately.  This data in this false buffer filled message
' is junk.  Workaround:  ask for N+1 buffers and ignore the first buffer.
'
' This effect is not seen for single channel tasks.
If bufIndex <> 0 Then
' allocate array for the data and some other variables that will be needed
ReDim AIData(SR.Sel_chan_N) As Single  ' allocate an array for the buffer of data
Dim dummy As Single
Dim i As Integer
List1.Clear  ' clear the list box

' the BufferFilled message contains the bufIndex that is ready for conversion
dummy = SR.VBArrayBufferConvert(bufIndex, 0, 4, AIData, DL_tSINGLE, 0, 0)
For i = 0 To 3
List1.AddItem "sample #: " & Str(i) & "  " & Str(Format(AIData(i), "##.##0"))
Next i
End If
End Sub
